# Pull Request Template

## Type of Change
**Select ONE type only. Multi-purpose PRs will be rejected.**

- [ ] 🐛 Bug fix (non-breaking change which fixes an issue)
- [ ] ✨ New feature (non-breaking change which adds functionality)
- [ ] 🔧 Improvement/Enhancement (non-breaking change which improves existing functionality)
- [ ] 📖 Documentation update
- [ ] 🧹 Code cleanup/refactoring (no functional changes)
- [ ] ⚡ Performance improvement
- [ ] 🔒 Security fix

## Description
**Provide a clear and detailed description of what this PR accomplishes.**

### What does this PR do?


### Why is this change needed?


### How does this change should be used and documented?


## Related Issues
**Link any related issues using GitHub keywords (e.g., "Fixes #123", "Closes #456")**

-

## Testing
**Describe how you tested your changes**

- [ ] I have tested this change locally
- [ ] I have added/updated unit tests where appropriate
- [ ] All existing tests pass
- [ ] I have tested this with different PHP versions (if applicable)

## Breaking Changes
**Does this PR introduce any breaking changes?**

- [ ] No breaking changes
- [ ] Yes, this PR introduces breaking changes (explain below)

**If yes, describe the breaking changes and migration path:**


## Documentation
**Documentation updates (check all that apply)**

- [ ] No documentation changes needed
- [ ] I have updated relevant documentation
- [ ] Documentation will be updated in a separate PR
- [ ] New documentation needs to be created

## Checklist
**Ensure all items are checked before submitting**

- [ ] My code follows the project's coding standards (PHPStan)
- [ ] I have performed a self-review of my code
- [ ] My changes generate no new warnings or errors
- [ ] My commit messages are clear and descriptive
- [ ] This PR addresses only ONE specific goal/issue

## Additional Notes
**Any additional information, concerns, or questions for reviewers**

