<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Video\V1\Room;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class RoomRecordingContext extends InstanceContext {
    /**
     * Initialize the RoomRecordingContext
     *
     * @param Version $version Version that contains the resource
     * @param string $roomSid The SID of the Room resource with the recording to
     *                        fetch
     * @param string $sid The SID that identifies the resource to fetch
     */
    public function __construct(Version $version, $roomSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['roomSid' => $roomSid, 'sid' => $sid, ];

        $this->uri = '/Rooms/' . \rawurlencode($roomSid) . '/Recordings/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the RoomRecordingInstance
     *
     * @return RoomRecordingInstance Fetched RoomRecordingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): RoomRecordingInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new RoomRecordingInstance(
            $this->version,
            $payload,
            $this->solution['roomSid'],
            $this->solution['sid']
        );
    }

    /**
     * Delete the RoomRecordingInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Video.V1.RoomRecordingContext ' . \implode(' ', $context) . ']';
    }
}